﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    public class MessageLinkDataTable : DataTable
    {
        public MessageLinkDataTable()
        {
            this.Columns.Add(new DataColumn("ID", typeof(int)));
            this.Columns.Add(new DataColumn("PARENT", typeof(int)));
            this.Columns.Add(new DataColumn("CHILD", typeof(int)));
        }

        public MessageLinkDataRow this[int index]
        {
            get
            {
                return (MessageLinkDataRow)Rows[index];
            }
        }

        public void Add(MessageLinkDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(MessageLinkDataRow row)
        {
            this.Rows.Remove(row);
        }

        public MessageLinkDataRow GetNewRow()
        {
            MessageLinkDataRow row = (MessageLinkDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(MessageLinkDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new MessageLinkDataRow(builder);
        }

        public IEnumerator<MessageLinkDataRow> GetEnumerator()
        {
            List<MessageLinkDataRow> rows = new List<MessageLinkDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((MessageLinkDataRow)this.Rows[i]);
            }
            return rows.GetEnumerator();
        }
    }
}